import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { BunkerOverview, PageName } from 'client/bundles/types';

import 'client/components/text/index.css';
import './index.css';

import MenuSection from 'client/components/menu-section';

const b = cn('overview');
const bPageTitle = cn('page-title');

interface Props {
    overview?: BunkerOverview;
    title: string;
    pageName: PageName;
}

class Overview extends Component<Props> {

    render() {
        if (!this.props.overview) {
            return null;
        }

        const { text } = this.props.overview;

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{this.props.title}</h1>

                <MenuSection type="governance" pageName={this.props.pageName} />

                <article
                    className={b('text', ['text'])}
                    dangerouslySetInnerHTML={{ __html: text }}
                    />
            </div>
        );
    }

}

export default Overview;
