import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { PersonInfo } from 'client/bundles/types';

import Hint from 'client/components/hint';
import './index.css';

import 'client/components/wiki-text/index.css';

const b = cn('person');

interface Props {
    person: PersonInfo;
}

interface State {
    isBioOpened: boolean;
    nodeRef: HTMLDivElement | null;
}

class Person extends Component<Props, State> {
    constructor(props: Props) {
        super(props);

        this.state = {
            isBioOpened: false,
            nodeRef: null
        };
    }

    setNodeRef = (ref: HTMLDivElement): void => {
        this.setState({ nodeRef: ref });
    }

    toggleBio = () => {
        this.setState({ isBioOpened: !this.state.isBioOpened });
    }

    render() {
        const { name, position, photo, bio } = this.props.person;

        return (
            <div className={b({ 'bio-opened': this.state.isBioOpened })} ref={this.setNodeRef} onClick={this.toggleBio}>
                <div className={b('inner')}>
                    <div className={b('photo-box')}>
                        <img className={b('photo')} src={photo} alt={`${name} Photo`} />
                    </div>

                    <div className={b('info')}>
                        <h2 className={b('name')}>{name}</h2>
                        <p className={b('position')}>{position}</p>
                        <div className={b('info-bottom')}>
                            <div className={b('info-text')}>
                                Bio
                                <i className={b('info-text-control')} />
                            </div>
                        </div>
                    </div>
                </div>

                <article
                    className={b('bio')}
                    dangerouslySetInnerHTML={{ __html: bio }}
                    />

                <Hint
                    content={bio}
                    mixClassName={b('hint')}
                    parentNode={this.state.nodeRef}
                    width={360}
                    showCopyButton
                    />
            </div>
        );
    }

}

export default Person;
