import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { PhoneNumber } from 'client/bundles/types';

const b = cn('phone');

interface Props {
    phone: PhoneNumber;
}

class Phone extends Component<Props> {
    render() {
        const { phone } = this.props;

        return (
            <a href={`tel:${phone.split(' ').join('')}`} className={b()}>{phone}</a>
        );
    }
}

export default Phone;
