import cn from 'client/utils/cn';

import React, { Component } from 'react';

import Button from 'client/components/lego/button';

import Contact from 'client/components/contact';

import { ContactSectionAddress, ContactSectionForm, PrefooterData } from 'client/bundles/types';

import './index.css';

const b = cn('prefooter');

class Prefooter extends Component<PrefooterData> {

    renderSectionTitle = (title: string | undefined) => {
        if (!title) {
            return null;
        }

        return (<h3 className={b('company')}>{title}</h3>);
    }

    renderSectionLeft = (data: ContactSectionAddress) => {
        if (!data.name && !data.text) {
            return null;
        }

        return (
            <>
                <div className={b('section-head')}>
                    { this.renderSectionTitle(data.name) }
                    <h4 className={b('title')}>{data.text}</h4>
                </div>
                {
                    data.contact &&
                    <div className={b('contacts')}>
                        <Contact contact={data.contact} />
                    </div>
                }

                {
                    data.contacts &&
                    <div className={b('contacts')}>
                        <div className={b('contacts-column')}>
                            <Contact contact={data.contacts.headquaters} />
                            <Contact contact={data.contacts.ir} />
                            <Contact contact={data.contacts.secretary} contactId={'prefooter'} />
                        </div>

                        <div className={b('contacts-column')}>
                            <Contact contact={data.contacts.adv} />
                            <Contact contact={data.contacts.pr} />
                            <Contact contact={data.contacts.sustainability} />
                        </div>
                    </div>
                }
            </>
        );
    }

    renderButton = (data: ContactSectionForm) => {
        if (!data.buttonText || !data.buttonLink) {
            return null;
        }

        return (
            <Button
                className={b('button')}
                theme="action"
                size="m"
                type="link"
                rel="noopener noreferrer"
                url={data.buttonLink}
                >
                {data.buttonText}
            </Button>
        );
    }

    renderAdditionalInfo = (additionalInfo: string | undefined) => {
        if (!additionalInfo) {
            return null;
        }

        return (
            <div className={b('row')}>
                <div
                    className={b('additional')}
                    dangerouslySetInnerHTML={{ __html: additionalInfo }}
                    />
            </div>
        );
    }

    render() {
        const { amsterdamContacts, moscowContacts, ask, subscribe, additionalInfo } = this.props;

        return (
            <section className={b()}>
                <div className={b('content')}>
                    <div className={b('row')}>
                        <div className={b('column', { left: true })}>
                            {this.renderButton(subscribe)}
                        </div>

                        <div className={b('column', { center: true })} />

                        <div className={b('column', { right: true })}>
                            {this.renderButton(ask)}
                        </div>
                    </div>

                    <i className={b('line')} />

                    <div className={b('row')}>
                        <div className={b('column', { left: true })}>
                            {this.renderSectionLeft(moscowContacts)}
                        </div>

                        <div className={b('column', { center: true })} />

                        <div className={b('column', { right: true })}>
                            {this.renderSectionLeft(amsterdamContacts)}
                        </div>
                    </div>

                    {this.renderAdditionalInfo(additionalInfo)}
                </div>
            </section>
        );
    }

}

export default Prefooter;
