import cn from 'client/utils/cn';

import { PressReleaseItemData } from 'client/bundles/types';
import moment from 'moment';
import React, { Component } from 'react';

import './index.css';

const bDate = cn('date');

const b = cn('press-release-item');

interface Props {
    release: PressReleaseItemData;
}

class PressReleaseItem extends Component<Props> {
    render() {
        const { release } = this.props;

        if (!release) {
            return null;
        }

        return (
            <div className={b()}>
                <a
                    className={b('link')}
                    href={release.url}
                    >
                    <span className={bDate()}>
                        {moment(release.date).format('MMMM DD, YYYY')}
                    </span>
                    <span className={b('title')}>
                        {release.title}
                    </span>
                </a>
            </div>
        );
    }

}

export default PressReleaseItem;
