import cn from 'client/utils/cn';

import { PagePressReleasesProps, PressReleaseItemData } from 'client/bundles/types';
import Breadcrumbs from 'client/components/breadcrumbs';

import React, { Component } from 'react';

import 'client/components/text/index.css';
import './index.css';

import Subscribe from 'client/components/subscribe';

const _ = require('lodash');

const b = cn('press-release');
const bPageTitle = cn('page-title');

interface Props extends PagePressReleasesProps {
    baseUrl: string;
    sectionTitle: string;
}

class PressRelease extends Component<Props> {
    renderRelease = (item: PressReleaseItemData) => {
        return (
            item.markup ?
                <div
                    className={b('text', ['text'])}
                    dangerouslySetInnerHTML={{ __html: item.markup }}
                    /> :
                null
        );
    }

    renderNoItem = (yearLink: string) => {
        return (
            <div>
                We are sorry, the Press Release you requested cannot be found.
                <br /><br />
                Please check the URL or visit <a href={yearLink}>Press Releases page</a>.
            </div>
        );
    }

    render() {
        const { item, sectionTitle, currentYear, baseUrl } = this.props;

        if (!item) {
            return null;
        }

        const yearLink = `${baseUrl}?year=${currentYear}`;

        return (
            <div className={b()}>
                <Breadcrumbs text={sectionTitle} link={yearLink} />

                <h1 className={bPageTitle()}>{item.title}</h1>

                {item && !_.isEmpty(item) ?
                    <div className={b('content')}>
                        {this.renderRelease(item)}

                        <div className={b('subscribe')}>
                            <Subscribe />
                        </div>
                    </div> :
                    this.renderNoItem(yearLink)
                }
            </div>
        );
    }

}

export default PressRelease;
