import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { PagePressReleasesProps } from 'client/bundles/types';
import { AutoscrollerStoragePrefix } from 'client/components/helpers/autoscroller';
import MenuYears from 'client/components/menu-years';
import PressReleaseItem from 'client/components/press-release-item';
import Subscribe from 'client/components/subscribe';

import './index.css';

const b = cn('press-releases');
const bPageTitle = cn('page-title');

interface Props extends PagePressReleasesProps {
    baseUrl: string;
}

class PressReleases extends Component<Props> {
    renderNoData = () => {
        return (
            <div className={b('message')}>
                Something went wrong.<br /><br />
                Try refreshing the page or come back later.
            </div>
        );
    }

    render() {
        const { title, items, years, currentYear } = this.props;

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                <div className={b('filters')}>
                    {currentYear && years && years.length > 0 &&
                        <MenuYears
                            currentYear={currentYear}
                            years={years}
                            storagePrefix={AutoscrollerStoragePrefix.PressReleases}
                            />
                    }
                </div>

                {items && items.length > 0 ?
                    <div className={b('content')}>
                        <div className={b('items')}>
                            { items.map(item => (<PressReleaseItem release={item} key={item.date} />)) }
                        </div>

                        <div className={b('subscribe')}>
                            <Subscribe />
                        </div>
                    </div> :
                    this.renderNoData()
                }
            </div>
        );
    }
}

export default PressReleases;
