import cn from 'client/utils/cn';

import React, { Component } from 'react';

import Breadcrumbs from 'client/components/breadcrumbs';
import MenuSection from 'client/components/menu-section';

import { PagePrinciplesProps } from 'client/bundles/types';
import './index.css';

const b = cn('principles');
const bPageTitle = cn('page-title');

class Principles extends Component<PagePrinciplesProps> {
    renderListItem = (item: string, index: number) => {
        return (
            <div className={b('item')} key={index} dangerouslySetInnerHTML={{ __html: item }} />
        );
    }

    render() {
        const { title, section, sectionId } = this.props;

        return (
            <div className={b()}>
                <Breadcrumbs text={'IR Home'} link={'/'} />

                <h1 className={bPageTitle()}>{title}</h1>

                <MenuSection type="principles" pageName={sectionId} />

                <div className={b('content')}>
                    <div className={b('image', { type: sectionId })} />

                    <div className={b('items')}>{section.list.map(this.renderListItem)}</div>
                </div>
            </div>
        );
    }

}

export default Principles;
