import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { MenuItem } from 'client/bundles/types';
import './index.css';

const b = cn('site-menu');

interface Props {
    items: MenuItem[];
}

class SiteMenu extends Component<Props> {
    renderLink = (item: MenuItem) => {
        return (
            <a href={item.url} className={b('link', { active: item.isCurrent })} key={item.id}>
                { item.title }
            </a>
        );
    }

    render() {
        const { items } = this.props;

        if (!items || items.length === 0) {
            return null;
        }

        return (
            <nav className={b()}>
                <div className={b('inner')}>
                    <div className={b('nav')}>
                        {items.map(this.renderLink)}
                    </div>
                </div>
            </nav>
        );
    }
}

export default SiteMenu;
