import 'slick-carousel/slick/slick.css';

import './index.css';

import cn from 'client/utils/cn';
import React, { Component, TouchEvent } from 'react';
import Slider from 'react-slick';

const SETTINGS = {
    autoplaySpeed: 6 * 1000,
    autoplay: true,
    dots: true,
    infinite: true,
    easing: 'ease-in-out',
    speed: 600,
    slidesToShow: 1,
    slidesToScroll: 1,
    arrows: false
};

const b = cn('slider2');

interface Props {
    classes: string[];
}

class Slider2 extends Component<Props> {
    private firstClientX: number;
    private clientX: number;

    constructor(props: Props) {
        super(props);

        this.touchStart = this.touchStart.bind(this);
        this.preventTouch = this.preventTouch.bind(this);
    }

    componentDidMount() {
        // @ts-ignore
        window.addEventListener('touchstart', this.touchStart);
        // @ts-ignore
        window.addEventListener('touchmove', this.preventTouch, { passive: false });
    }

    componentWillUnmount() {
        // @ts-ignore
        window.removeEventListener('touchstart', this.touchStart);
        // @ts-ignore
        window.removeEventListener('touchmove', this.preventTouch, { passive: false });
    }

    render() {
        const { classes } = this.props;

        return (
            <Slider
                {...SETTINGS}
                className={b()}
                dotsClass={b('bullets')}
                >
                {classes.map(className => (
                    <div key={className} className={b('image-item')}>
                        <div className={b('image', [className])} />
                    </div>
                ))}
            </Slider>
        );
    }
    private touchStart(e: TouchEvent): void {
        this.firstClientX = e.touches[0].clientX;
    }

    // Вертикальный скрол запрещен во время горизонтального swipe
    // https://github.com/akiran/react-slick/issues/1240
    private preventTouch(e: TouchEvent): void {
        const minValue = 5; // threshold

        this.clientX = e.touches[0].clientX - this.firstClientX;

        if (Math.abs(this.clientX) > minValue) {
            e.preventDefault();
        }
    }
}

export default Slider2;
