import cn from 'client/utils/cn';

import React, { Component } from 'react';

import MenuSection from 'client/components/menu-section';

import './index.css';

import IframeXDM from 'client/components/iframeXDM';

import { PageName } from 'client/bundles/types';

const b = cn('stocks');
const bPageTitle = cn('page-title');

interface Props {
    title: string;
    pageName: PageName;
    stocksUrl: string;
}

class Stocks extends Component<Props> {
    render() {
        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{this.props.title}</h1>

                <MenuSection type="shareholders" pageName={this.props.pageName} />

                <IframeXDM url={this.props.stocksUrl} />
            </div>
        );
    }
}

export default Stocks;
