import cn from 'client/utils/cn';
import moment from 'moment';

import React, { Component } from 'react';

import MenuSection from 'client/components/menu-section';

import { PageStructureProps, ShareholdersData, SharesData } from 'client/bundles/types';
import './index.css';

const b = cn('structure');
const bDate = cn('date');
const bPageTitle = cn('page-title');

class Structure extends Component<PageStructureProps> {
    renderSharesData = (shares: SharesData) => {
        return (
            <div className={b('shares')}>
                <div className={b('total-text')}>The total number of shares issued and outstanding:</div>
                <div className={b('total')}>{shares.total}</div>

                <div className={b('including')}>
                    <div className={b('including-text')}>Including:</div>
                    {shares.including &&
                        <div className={b('shares-info')}>
                            <div className={b('shares-info-item')}>
                                <strong className={b('shares-number')}>{shares.including.classA}</strong> Class A shares
                            </div>
                            <div className={b('shares-info-item')}>
                                <strong className={b('shares-number')}>{shares.including.classB}</strong> Class B shares
                            </div>
                            <div className={b('shares-info-item')}>One Priority share</div>
                        </div>
                    }
                </div>

                <div className={b('excluding')}>
                    Excluding {shares.excluding} Class A shares held in treasury as a result of Yandex’s share repurchase program
                </div>
            </div>
        );
    }

    renderShareholdersData = (shareholders: ShareholdersData) => {
        return (
            <div className={b('shareholders')}>
                <div className={b('shareholders-table')}>
                    <div className={b('shareholders-head')}>
                        <div className={b('shareholders-header')}>Shareholders</div>
                        <div className={b('shareholders-percent')}>Economic Ownership,&nbsp;%</div>
                        <div className={b('shareholders-percent')}>Voting Power,&nbsp;%</div>
                    </div>
                    <div className={b('shareholders-item')}>
                        <div className={b('shareholders-header')}><strong>{shareholders.preIPO.title}</strong></div>
                        <div className={b('shareholders-percent')}><strong>{shareholders.preIPO.eo}</strong></div>
                        <div className={b('shareholders-percent')}><strong>{shareholders.preIPO.vp}</strong></div>
                    </div>
                    <div className={b('shareholders-item')}>
                        <div className={b('shareholders-header', { details: true })}>
                            <div className={b('shareholders-header-details')}>{shareholders.volozh.title}</div>
                        </div>
                        <div className={b('shareholders-percent')}>{shareholders.volozh.eo}</div>
                        <div className={b('shareholders-percent')}>{shareholders.volozh.vp}</div>
                    </div>
                    <div className={b('shareholders-item')}>
                        <div className={b('shareholders-header', { details: true })}>
                            <div className={b('shareholders-header-details')}>{shareholders.otherDirectors.title}</div>
                        </div>
                        <div className={b('shareholders-percent')}>{shareholders.otherDirectors.eo}</div>
                        <div className={b('shareholders-percent')}>{shareholders.otherDirectors.vp}</div>
                    </div>
                    <div className={b('shareholders-item')}>
                        <div className={b('shareholders-header')}><strong>{shareholders.otherPreIPO.title}</strong></div>
                        <div className={b('shareholders-percent')}><strong>{shareholders.otherPreIPO.eo}</strong></div>
                        <div className={b('shareholders-percent')}><strong>{shareholders.otherPreIPO.vp}</strong></div>
                    </div>
                    <div className={b('shareholders-item', { total: true })}>
                        <div className={b('shareholders-header')}><strong>{shareholders.publicInvestors.title}</strong></div>
                        <div className={b('shareholders-percent')}><strong>{shareholders.publicInvestors.eo}</strong></div>
                        <div className={b('shareholders-percent')}><strong>{shareholders.publicInvestors.vp}</strong></div>
                    </div>
                    <div className={b('shareholders-item')}>
                        <div className={b('shareholders-header')}><strong>{shareholders.total.title}</strong></div>
                        <div className={b('shareholders-percent')}><strong>{shareholders.total.eo}</strong></div>
                        <div className={b('shareholders-percent')}><strong>{shareholders.total.vp}</strong></div>
                    </div>
                </div>
            </div>
        );
    }

    render() {
        const { structure, title, pageName } = this.props;

        if (!structure) {
            return null;
        }

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                <MenuSection type="shareholders" pageName={pageName} />

                <p className={b('date')}>
                    Data as of&nbsp;
                    <span className={bDate()}>
                        {moment(structure.date).format('MMMM DD, YYYY')}
                    </span>
                </p>

                <div className={b('content')}>
                    {this.renderSharesData(structure.shares)}
                    {this.renderShareholdersData(structure.shareholders)}
                </div>
            </div>
        );
    }

}

export default Structure;
