import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { BunkerSustainability } from 'client/bundles/types';
import Breadcrumbs from 'client/components/breadcrumbs';
import DocsList from 'client/components/docs-list';

const b = cn('sustainability');
const bPageTitle = cn('page-title');

interface Props {
    sustainability?: BunkerSustainability;
}

class Sustainability extends Component<Props> {

    render() {
        if (!this.props.sustainability) {
            return null;
        }

        const { title, text, docs } = this.props.sustainability;

        return (
            <div className={b()}>
                <Breadcrumbs link="/" text={'IR Home'} />

                <h1 className={bPageTitle({ type: 'border' })}>{title}</h1>

                {text}

                <DocsList docs={docs} />
            </div>
        );
    }
}

export default Sustainability;
