import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { BunkerWebcast } from 'client/bundles/types';

import './index.css';

const b = cn('webcast');
const bPageTitle = cn('page-title');

interface Props {
    webcast?: BunkerWebcast;
}

class Webcast extends Component<Props> {

    render() {
        if (!this.props.webcast) {
            return null;
        }

        const { title, link } = this.props.webcast;

        // Doc: https://github.yandex-team.ru/mm-interfaces/fiji/blob/dev/contribs/video-player/VH.md
        const params = '?from=partner&mute=1&autoplay=0&tv=0&no_ad=false&loop=false&play_on_visible=false&branding=0';
        const additionalParams = '&recommendations=off&report=0&hidden=externalPlayback';

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                <iframe
                    src={`${link}${params}${additionalParams}`}
                    className={b('iframe')}
                    width="560"
                    height="315"
                    scrolling="no"
                    allowFullScreen
                    allow="autoplay; fullscreen; accelerometer; gyroscope; picture-in-picture; encrypted-media"
                    />
            </div>
        );
    }
}

export default Webcast;
