import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Analysts from 'client/components/analysts';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class AnalystsPage extends Component<Props> {
    render() {
        const metaTitle = `${this.props.data.analysts.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Analysts analystsData={this.props.data.analysts} />
            </>
        );
    }
}
