import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Bonds from 'client/components/bonds';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class BondsPage extends Component<Props> {
    render() {
        const { bonds } = this.props.data;

        const metaTitle = `${bonds.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Bonds bonds={bonds} />
            </>
        );
    }
}
