import Helmet from 'react-helmet';

import React, { Component } from 'react';

import { BundleData } from 'client/bundles/types';

import ContactsGovernance from 'client/components/contacts-governance';

interface Props {
    data: BundleData;
}

export default class ContactsGovernancePage extends Component<Props> {
    render() {
        const { pageName, sectionTitle, contactsGovernance, yandexFormEmbedPath, boardFormUrl } = this.props.data;

        const metaTitle = `${contactsGovernance.title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />

                    <script src={yandexFormEmbedPath} />
                </Helmet>

                <ContactsGovernance pageName={pageName} title={sectionTitle} boardFormUrl={boardFormUrl} />
            </>
        );
    }
}
