import Helmet from 'react-helmet';

import React, { Component } from 'react';

import AskForm from 'client/components/ask-form';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class ContactsPage extends Component<Props> {
    render() {
        const title = 'Ask a question';
        const metaTitle = `${title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />

                    <script src={this.props.data.yandexFormEmbedPath} />
                </Helmet>

                <AskForm askFormUrl={this.props.data.askFormUrl} title={title} />
            </>
        );
    }
}
