import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Directors from 'client/components/directors';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class DirectorsPage extends Component<Props> {
    render() {
        const { directors, pageName, sectionTitle } = this.props.data;

        const metaTitle = `${directors.title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Directors list={directors.list} selectedCommittee={directors.selectedCommittee} title={sectionTitle} pageName={pageName} />
            </>
        );
    }
}
