import Helmet from 'react-helmet';

import React, { Component } from 'react';

import EmailForm from 'client/components/email-form';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class EmailAlertsPage extends Component<Props> {
    render() {
        const title = 'Email Alerts Subscription';
        const metaTitle = `${title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <EmailForm emailFormUrl={this.props.data.emailFormUrl} title={title} />
            </>
        );
    }
}
