import Helmet from 'react-helmet';

import React, { Component } from 'react';

import { BundleData } from 'client/bundles/types';

import Events from 'client/components/events';

interface Props {
    data: BundleData;
}

export default class EventsPage extends Component<Props> {
    render() {
        const { events } = this.props.data;
        const metaTitle = `${events.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Events
                    title={events.title}
                    yearEvents={events.yearEvents}
                    years={events.years}
                    currentYear={events.currentYear}
                    />
            </>
        );
    }
}
