import Helmet from 'react-helmet';

import React, { Component } from 'react';

import { BundleData } from 'client/bundles/types';

import FaqGovernance from 'client/components/faq-governance';

interface Props {
    data: BundleData;
}

export default class FaqGovernancePage extends Component<Props> {
    render() {
        const { pageName, sectionTitle, faqGovernance } = this.props.data;

        const metaTitle = `${faqGovernance.title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <FaqGovernance faq={faqGovernance} title={sectionTitle} pageName={pageName} />
            </>
        );
    }
}
