import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Faq from 'client/components/faq';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class FaqPage extends Component<Props> {
    render() {
        const faqData = this.props.data.faq;
        const metaTitle = `${faqData.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Faq faq={faqData} />
            </>
        );
    }
}
