import Helmet from 'react-helmet';

import React, { Component } from 'react';

import { BundleData } from 'client/bundles/types';
import Financial from 'client/components/financial';
import Financials from 'client/components/financials';

interface Props {
    data: BundleData;
}

export default class FinancialsPage extends Component<Props> {
    render() {
        const { financials, baseUrl } = this.props.data;
        const title = financials.quarterReport ?
            financials.quarterReport.title :
            `${financials.title} ${financials.currentYear}`;
        const metaTitle = `${title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                {financials.quarterReport ?
                    <Financial
                        title={financials.title}
                        quarterReport={financials.quarterReport}
                        currentYear={financials.currentYear}
                        baseUrl={baseUrl}
                        /> :
                    <Financials
                        title={financials.title}
                        yearReports={financials.yearReports}
                        years={financials.years}
                        currentYear={financials.currentYear}
                        />
                }
            </>
        );
    }
}
