import Helmet from 'react-helmet';

import React, { Component } from 'react';

import { BundleData } from 'client/bundles/types';
import KeyBusinesses from 'client/components/key-businesses';

interface Props {
    data: BundleData;
}

export default class KeyBusinessesPage extends Component<Props> {
    render() {
        const { title, structure, note } = this.props.data.keyBusinesses;
        const metaTitle = `${title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <KeyBusinesses structure={structure} title={title} note={note} />
            </>
        );
    }
}
