import Helmet from 'react-helmet';

import React, { Component } from 'react';

import KeyDocuments from 'client/components/key-documents';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class DocumentsPage extends Component<Props> {
    render() {
        const { documents, pageName, sectionTitle } = this.props.data;

        const metaTitle = `${documents.title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <KeyDocuments documents={documents} title={sectionTitle} pageName={pageName} />
            </>
        );
    }
}
