import Helmet from 'react-helmet';

import React, { Component } from 'react';

import LatestPresentation from 'client/components/latest-presentation';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class LatestPresentationPage extends Component<Props> {
    render() {
        const { latestPresentation } = this.props.data;

        const metaTitle = `${latestPresentation.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <LatestPresentation latestPresentation={latestPresentation} />
            </>
        );
    }
}
