import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Main from 'client/components/main';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class MainPage extends Component<Props> {
    render() {
        const { main } = this.props.data;

        const metaTitle = `${main.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Main {...main} />
            </>
        );
    }
}
