import Helmet from 'react-helmet';

import React, { Component } from 'react';

import { BundleData } from 'client/bundles/types';

import Management from 'client/components/management';

interface Props {
    data: BundleData;
}

export default class ManagementPage extends Component<Props> {
    render() {
        const { management, pageName, sectionTitle } = this.props.data;

        const metaTitle = `${management.title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Management management={management} title={sectionTitle} pageName={pageName} />
            </>
        );
    }
}
