import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Meetings from 'client/components/meetings';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class MeetingsPage extends Component<Props> {
    render() {
        const { meetings, pageName } = this.props.data;

        const sectionTitle = 'For Shareholders';
        const metaTitle = `${meetings.title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Meetings meetings={meetings} title={sectionTitle} pageName={pageName} />
            </>
        );
    }
}
