import Helmet from 'react-helmet';

import React, { Component } from 'react';

import NotFound from 'client/components/not-found';

export default class NotFoundPage extends Component {
    render() {
        const metaTitle = 'Page Not Found | Investor Relations | Yandex N.V.';

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <NotFound />
            </>
        );
    }
}
