import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Principles from 'client/components/principles';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class PrinciplesPage extends Component<Props> {
    render() {
        const { principles } = this.props.data;

        const metaTitle = `${principles.title}: ${principles.section.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Principles {...principles} />
            </>
        );
    }
}
