import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Overview from 'client/components/overview';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class OverviewPage extends Component<Props> {
    render() {
        const { overview, pageName, sectionTitle } = this.props.data;

        const metaTitle = `${overview.title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Overview overview={overview} title={sectionTitle} pageName={pageName} />
            </>
        );
    }
}
