import Helmet from 'react-helmet';

import React, { Component } from 'react';

import PressRelease from 'client/components/press-release';
import PressReleases from 'client/components/press-releases';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class PressReleasesPage extends Component<Props> {
    render() {
        const { pressReleases, baseUrl } = this.props.data;
        const { item, items, years, currentYear } = pressReleases;

        const sectionTitle = 'Press Releases';
        const title = pressReleases.item?.title ? pressReleases.item.title : `${sectionTitle} ${currentYear}`;
        const metaTitle = `${title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                {item ?
                    <PressRelease
                        sectionTitle={sectionTitle}
                        item={item}
                        currentYear={currentYear}
                        baseUrl={baseUrl}
                        /> :
                    <PressReleases
                        title={sectionTitle}
                        items={items}
                        currentYear={currentYear}
                        baseUrl={baseUrl}
                        years={years}
                        />
                }

            </>
        );
    }
}
