import Helmet from 'react-helmet';

import React, { Component } from 'react';

import SecFilingView from 'client/components/sec-filing';
import SecFilings from 'client/components/sec-filings';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class SecPage extends Component<Props> {
    render() {
        const { sec, baseUrl } = this.props.data;
        const sectionTitle = 'SEC Filings';
        const title = sec.singleFiling ? sec.singleFiling.title : sectionTitle;
        const props = {
            currentYear: sec.currentYear,
            groupId: sec.groupId,
            years: sec.years,
            types: sec.types,
            singleFiling: sec.singleFiling,
            baseUrl,
            title
        };
        const metaTitle = `${title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                {sec.singleFiling ?
                    <SecFilingView {...props} singleFiling={sec.singleFiling} sectionTitle={sectionTitle} /> :
                    <SecFilings {...props} yearFilings={sec.yearFilings} />
                }
            </>
        );
    }
}
