import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Stocks from 'client/components/stocks';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class StocksPage extends Component<Props> {
    render() {
        const sectionTitle = 'For Shareholders';
        const title = 'Stock Data';
        const metaTitle = `${title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        const { stocksUrl, pageName } = this.props.data;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Stocks stocksUrl={stocksUrl} title={sectionTitle} pageName={pageName} />
            </>
        );
    }
}
