import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Structure from 'client/components/structure';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class StructurePage extends Component<Props> {
    render() {
        const { structure, pageName } = this.props.data;

        const sectionTitle = 'For Shareholders';
        const metaTitle = `${structure.title} | ${sectionTitle} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Structure structure={structure} title={sectionTitle} pageName={pageName} />
            </>
        );
    }
}
