import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Sustainability from 'client/components/sustainability';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class SustainabilityPage extends Component<Props> {
    render() {
        const { sustainability } = this.props.data;

        const metaTitle = `${sustainability.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Sustainability sustainability={sustainability} />
            </>
        );
    }
}
