import Helmet from 'react-helmet';

import React, { Component } from 'react';

import Webcast from 'client/components/webcast';

import { BundleData } from 'client/bundles/types';

interface Props {
    data: BundleData;
}

export default class WebcastPage extends Component<Props> {
    render() {
        const { webcast } = this.props.data;

        const metaTitle = `${webcast.title} | Investor Relations | Yandex N.V.`;

        return (
            <>
                <Helmet>
                    <title>{metaTitle}</title>
                    <meta name="title" content={metaTitle} />
                    <meta name="og:title" content={metaTitle} />
                    <meta name="twitter:title" content={metaTitle} />
                </Helmet>

                <Webcast webcast={webcast} />
            </>
        );
    }
}
