export interface MenuItemLink {
    href: string;
    title: string;
}

export interface MenuItems {
    [key: string]: MenuItemLink;
}

const SHAREHOLDERS: MenuItems = {
    structure: { href: '/shareholder-structure', title: 'Shareholder Structure' },
    meetings: { href: '/shareholder-meetings', title: 'Shareholder Meetings' },
    stocks: { href: '/stock-information', title: 'Stock data' }
};

const PRINCIPLES: MenuItems = {
    general: { href: '/our-principles?section=general', title: 'General Principles' },
    business: { href: '/our-principles?section=business', title: 'Business' },
    data: { href: '/our-principles?section=data', title: 'Data' },
    society: { href: '/our-principles?section=society', title: 'Society' },
    competition: { href: '/our-principles?section=competition', title: 'Competition' },
    ai: { href: '/our-principles?section=ai', title: 'Artificial Intelligence' },
    distribution: { href: '/our-principles?section=distribution', title: 'Product Distribution' }
};

const GOVERNANCE: MenuItems = {
    overview: { href: '/corporate-governance/overview', title: 'Overview' },
    directors: { href: '/corporate-governance/board-of-directors', title: 'Board of Directors' },

    /* management: { href: '/corporate-governance/management', title: 'Management' }, */
    keyDocuments: { href: '/corporate-governance/key-documents', title: 'Key Documents' },
    faqGovernance: { href: '/corporate-governance/faq', title: 'FAQ' },
    contactsGovernance: { href: '/corporate-governance/contacts', title: 'Contacts' }
};

const PAGES = {
    shareholders: SHAREHOLDERS,
    principles: PRINCIPLES,
    governance: GOVERNANCE
};

export { PAGES };
