import { EVAL, INLINE, NONCE, NONE, SELF } from '@yandex-int/express-yandex-csp';
import { Policies } from 'csp-header';

const policies: Policies = {
    'connect-src': [
        SELF,
        'https://yandex.com/clck'
    ],
    'default-src': [
        NONE
    ],
    'script-src': [
        NONCE,
        EVAL,
        INLINE
    ],
    'style-src': [
        INLINE
    ],
    'img-src': [
        SELF,
        'ir-docs.s3.yandex.net'
    ],
    'frame-src': [
        INLINE,
        'charts3.equitystory.com',
        'irpages2.eqs.com',
        'forms.yandex.ru',
        's3.mds.yandex.net',
        'frontend.vh.yandex.ru',
        'datalens.yandex',
        'passport.yandex.ru'
    ]
};

export default policies;
