import { join } from 'path';

import { AppConfig } from '@yandex-int/yandex-cfg';
import deployStream from '@yandex-int/yandex-logger/streams/deploy';

import defaultsCsp from './csp/defaults';

const SEC_FILINGS_UPDATE_INTERVAL = 1000 * 60 * 10; // 10 min

const config: AppConfig = {
    yandexServiceId: 'ir',

    bunker: {
        api: 'http://bunker-api-ir.yandex.net/v1',
        project: 'ir-www-v2',
        cache: true
    },

    secFilings: {
        url: 'http://irpages2.eqs.com/websites/yandex/English/15/json-feed.html',
        updateInterval: SEC_FILINGS_UPDATE_INTERVAL
    },

    zora: {
        host: 'zora.yandex.net',
        port: 8166,
        sourceName: 'ir',
        timeout: 1000 * 10,
        cacheTime: SEC_FILINGS_UPDATE_INTERVAL
    },

    csp: {
        presets: defaultsCsp,
        policies: {},
        serviceName: 'ir-www',
        useDefaultReportUri: true
    },

    askFormUrl: 'https://forms.yandex.ru/surveys/10024983.3850d49355a1b2af5019e5d46c6a5c56cfc96525/?iframe=1&lang=en',

    boardFormUrl: 'https://forms.yandex.ru/surveys/10028443.860b923b9ce859b7173e54588d3e0354040c885e/?iframe=1&lang=en',

    yandexFormEmbedPath: 'https://yastatic.net/q/forms-frontend-ext/_/embed.js',

    easyXDM: 'https://ir-static.s3.yandex.net/libs/easyXDM/easyXDM.min.js',

    emailFormUrl: 'https://irpages2.eqs.com/websites/yandex/English/9010/contact-manager.html',

    httpUatraits: {
        server: 'http://uatraits.qloud.yandex.ru',
        clientOptions: {
            timeout: 100
        }
    },

    langs: ['en'],

    logger: {
        fields: {
            environment: process.env.NODE_ENV,
            release: process.env.APP_VERSION
        },
        name: 'ir-www',
        streams: [
            {
                level: 'info',
                stream: deployStream()
            }
        ]
    },

    metrikaCounterId: 70090423,

    metrikaOptions: {
        clickmap: true,
        trackLinks: true,
        webvisor: true,
        accurateTrackBounce: true
    },

    stocksUrl: 'https://charts3.equitystory.com/chart/yandex-v31/English/?scroll',

    stocksTeaserUrl: 'https://charts3.equitystory.com/teaser/yandex-v31/English/',

    static: {
        dir: join(__dirname, '..', 'client'),
        staticDir: join(__dirname, '..', '..', 'static')
    },

    render: {
        isHot: false
    },

    tvm: {
        serverUrl: 'http://localhost:8001',
        destinations: ['zora', 'blogsApi'],
        clientId: 'ir-www',
        token: process.env.TVMTOOL_LOCAL_AUTHTOKEN
    },

    blogsApi: {
        protocol: 'http:',
        host: 'blogs-api-production-hidden.yandex.net',
        port: '80',
        path: {
            post: '/v1/post/company-pr/{{postId}}/',
            posts: '/v1/posts/company-pr/',
            'posts-custom': '/v1/posts/custom/company-pr/',
            postsArchive: '/v1/posts/archive/company-pr/',
            subscribe: '/v1/subscribe/blog/email/{{blogId}}/',
            unsubscribe: '/v1/user/unsubscribes/email/{{blogId}}/{{userEmail}}/{{token}}'
        },
        blogId: '5af961241043ae52fad1d32f',
        updateIntervalRss: 1000 * 30 // 30 sec
    }

};

module.exports = config;
