import { AppConfig } from '@yandex-int/yandex-cfg';

import testingCsp from './csp/testing';

// env.js генерится при в сандбоксе при сборке в CI и используется только в рантайме
// eslint-disable-next-line import/no-unresolved, global-require
const APP_VERSION = process.env.APP_VERSION || require('../env.js').APP_VERSION;

const config: AppConfig = {
    bunker: {
        version: 'latest'
    },

    logger: {
        fields: {
            release: APP_VERSION
        }
    },

    csp: {
        presets: testingCsp
    },

    httpUatraits: {
        server: 'http://uatraits-test.qloud.yandex.ru'
    },

    static: {
        baseUrl: 'https://yastatic.net/s3/ir-static/static/',
        frozenPath: '/_',
        version: APP_VERSION
    }
};

module.exports = config;
