import express from 'express';

import { finalErrorHandler, logger, render } from 'server/middlewares';
import router from 'server/router';
import redirectsRouter from 'server/router/redirects';

const app = express();

app.disable('x-powered-by');
app.enable('trust proxy');
app.use(render);
app.use(logger);

redirectsRouter(app);
app.use(router);

app.use(finalErrorHandler);

export default app;
