import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function bonds(req: Request, res: Response, next: NextFunction) {
    const pageName = 'bonds';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, pageName);
    const bondsPageData = bunker.pages.bonds;

    if (!bondsPageData) {
        next();

        return;
    }

    const disclaimers = await Promise.all(bondsPageData.disclaimers.map(async disclaimer => {
        return await getFormattedText(disclaimer.text);
    }));

    bondsPageData.disclaimers.forEach((disclaimer, index) => {
        disclaimer.html = disclaimers[index];
    });

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        bonds: bondsPageData
    });
}
