import cfg from '@yandex-int/yandex-cfg';
import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';

export default function contactsGovernance(req: Request, res: Response, next: NextFunction) {
    const pageName = 'contactsGovernance';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, 'governance');

    if (!bunker.pages.governance || !bunker.pages.governance.contacts) {
        next();

        return;
    }

    const { title, contacts } = bunker.pages.governance;

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        sectionTitle: title,
        contactsGovernance: contacts,
        boardFormUrl: cfg.boardFormUrl,
        yandexFormEmbedPath: cfg.yandexFormEmbedPath
    });
}
