import cfg from '@yandex-int/yandex-cfg';
import { Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';

export default function contacts(req: Request, res: Response) {
    const pageName = 'contacts';
    const commonPageData = getCommonPageData(req, res, pageName);

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        askFormUrl: cfg.askFormUrl,
        yandexFormEmbedPath: cfg.yandexFormEmbedPath
    });
}
