import { COMMITTEE_TYPES, DirectorCommittee, DirectorData } from 'client/bundles/types';
import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function directors(req: Request, res: Response, next: NextFunction) {
    const pageName = 'directors';
    const { bunker, query: { committee } } = req;
    const commonPageData = getCommonPageData(req, res, 'governance');
    const bunkerDirectors = bunker.pages.governance?.directors;

    if (!bunkerDirectors) {
        next();

        return;
    }

    const isCommitteeValid = committee && typeof committee === 'string' && COMMITTEE_TYPES.includes(committee);
    const selectedCommittee = isCommitteeValid ? committee as DirectorCommittee : undefined;

    const { title, isWiki } = bunkerDirectors;

    let directorsList = bunkerDirectors.directors;

    if (isWiki) {
        directorsList = await Promise.all(directorsList.map(async (director: DirectorData) => {
            return {
                ...director,
                bio: await getFormattedText(director.bio)
            };
        }));
    }

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        sectionTitle: bunker.pages.governance!.title,
        directors: {
            title,
            list: getDirectorsCommittee(directorsList, selectedCommittee),
            selectedCommittee
        }
    });
}

function getDirectorsCommittee(list: DirectorData[], committee?: DirectorCommittee): DirectorData[] {
    if (!committee || committee === 'all') {
        return list;
    }

    return list.filter(director =>
        director.chairpersonCommittees.includes(committee) || director.memberCommittees.includes(committee)
    );
}
