import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function faqGovernance(req: Request, res: Response, next: NextFunction) {
    const pageName = 'faqGovernance';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, 'governance');

    if (!bunker.pages.governance || !bunker.pages.governance.faq) {
        next();

        return;
    }

    const { title, faq } = bunker.pages.governance;

    const { isWiki } = faq;
    let { questions } = faq;

    if (isWiki) {
        questions = await Promise.all(questions.map(async question => {
            return {
                ...question,
                answer: await getFormattedText(question.answer)
            };
        }));
    }

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        sectionTitle: title,
        faqGovernance: {
            ...faq,
            questions
        }
    });
}
