import { FaqListItem } from 'client/bundles/types';
import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function faq(req: Request, res: Response, next: NextFunction) {
    const pageName = 'faq';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, pageName);
    const faqData = bunker.pages.faq;

    if (!faqData) {
        next();

        return;
    }

    const preparedSection = async function (section: FaqListItem) {
        return await Promise.all(section.questions.map(async question => {
            const answer = faqData.isWiki ? await getFormattedText(question.answer) : question.answer;

            return {
                ...question,
                answer
            };
        }));
    };

    const preparedData = await Promise.all(faqData!.list.map(async section => {
        const questions = await preparedSection(section);

        return {
            ...section,
            questions
        };
    }));

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        faq: {
            ...faqData,
            list: preparedData
        }
    });
}
